//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define macroRandom (rand() / (double)SHORT_MAX)
//+------------------------------------------------------------------+
class C_Neuron
{
    private:
        uint    m_Inputs;
        double  m_bias,
                m_weight[];
//+------------------------------------------------------------------+
        inline double Cost(const double &train[])
        {
            double x, err;

            err = 0;
            for (uint c0 = 0; c0 < train.Size(); c0++)
            {
                x = 0;
                for(uint c1 = 0; c1 < m_Inputs; c1++, c0++)
                   x += (train[c0] * m_weight[c1]);
                err += MathPow((x + m_bias) - train[c0], 2);
            }

            return err;
        }
//+------------------------------------------------------------------+
    public :
//+------------------------------------------------------------------+
        C_Neuron(const uint nInputs = 1, double H = 1.0, double L = 0.0)
        {
            MathSrand(512);
            m_Inputs = nInputs;
            ArrayResize(m_weight, m_Inputs);
            for(uint c = 0; c < m_Inputs; c++)
                m_weight[c] = ((double)macroRandom * (H - L)) + L;
            m_bias = (double)macroRandom;
        }
//+------------------------------------------------------------------+
        ~C_Neuron()
        {
            ArrayFree(m_weight);
        }
//+------------------------------------------------------------------+
        void View_Variables(void)
        {
            Print("Bias: ", m_bias);
            for (uint c = 0, m = m_weight.Size(); c < m; c++)
                PrintFormat("Weight[%d]: %.16f", c, m_weight[c]);
        }
//+------------------------------------------------------------------+
        inline double Learning(const double &train[], const double epsilon = 1e-3, const ulong limit = ULONG_MAX)
        {
            double  err,
                    mem_b,
                    err_w[],
                    mem_w[];

            ArrayResize(err_w, m_Inputs);
            ArrayResize(mem_w, m_Inputs);
            for (ulong count = 0; (count < limit) && ((err = Cost(train)) > epsilon); count++)
            {
                ArrayCopy(mem_w, m_weight);
                for (uint c = 0, m = m_weight.Size(); c < m; c++)
                {
                    m_weight[c] += epsilon;
                    err_w[c] = Cost(train) - err;
                    m_weight[c] = mem_w[c];
                }
                mem_b = m_bias;
                m_bias += epsilon;
                m_bias = mem_b - (Cost(train) - err);
                for (uint c = 0, m = m_weight.Size(); c < m; c++)
                    m_weight[c] -= err_w[c];
            }
            ArrayFree(err_w);
            ArrayFree(mem_w);

            return err;
        }
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef macroRandom
//+------------------------------------------------------------------+